﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using ServiceData.Complex;
using System.ServiceModel.Activation;
using System.Runtime.Serialization;


namespace ServiceCommunication.ComplexService
{
    #region Service Interface

    [ServiceContract]
    //[ServiceKnownType(typeof(VariousEntities))]
    //[ServiceKnownType(typeof(BusinessEntity))]
    //[ServiceKnownType(typeof(CustomerEntity))]
    //[ServiceKnownType(typeof(VendorEntity))]
    public interface IComplexWCFService
    {
        [OperationContract]
        [CommunicationSupport.JsonMessageClass(typeof(VariousEntriesSave2))]
        VariousEntities Save2(VariousEntities variousEntities, string stringValue, VariousEntities various2, int intValue);
        [OperationContract]
        [CommunicationSupport.JsonMessageClass(typeof(VariousEntriesSave))]
        VariousEntities Save(VariousEntities variousEntities);
        [OperationContract]
        [CommunicationSupport.JsonMessageClass(typeof(BusinessEntitySaveBusiness))]
        BusinessEntity SaveBusiness(BusinessEntity business);
        [OperationContract]
        [CommunicationSupport.JsonMessageClass(typeof(CustomerEntitySaveCustomer))]
        CustomerEntity SaveCustomer(CustomerEntity customer);
        [OperationContract]
        [CommunicationSupport.JsonMessageClass(typeof(VendorEntitySaveVendor))]
        VendorEntity SaveVendor(VendorEntity vendor);
    }

    #endregion

    #region Json Message Classes

    [DataContract]
    public class VariousEntriesSave2
    {
        [DataMember]
        public VariousEntities variousEntities { get; set; }
        [DataMember]
        public string stringValue { get; set; }
        [DataMember]
        public VariousEntities various2 { get; set; }
        [DataMember]
        public int intValue { get; set; }
    }   

    [DataContract]
    public class VariousEntriesSave
    {
        [DataMember]
        public VariousEntities variousEntities { get; set; }
    }

    [DataContract]
    public class BusinessEntitySaveBusiness
    {
        [DataMember]
        public BusinessEntity business { get; set; }
    }

    [DataContract]
    public class CustomerEntitySaveCustomer
    {
        [DataMember]
        public CustomerEntity customer { get; set; }
    }

    [DataContract]
    public class VendorEntitySaveVendor
    {
        [DataMember]
        public VendorEntity vendor { get; set; }
    }

    #endregion

    #region Service Implementation

    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    public class ComplexWCFService: IComplexWCFService
    {

        public VariousEntities Save2(VariousEntities variousEntities, string stringValue, VariousEntities various2, int intValue)
        {
            return Save(variousEntities);
        }
 
        public VariousEntities Save(VariousEntities variousEntities)
        {
            foreach (object entity in variousEntities.Entities)
            {
                CustomerEntity customer = entity as CustomerEntity;
                if (customer != null)
                {
                    customer.ApprovalDate = DateTime.Now;
                    customer.Id = GetNextId();
                    break;
                }

                VendorEntity vendor = entity as VendorEntity;
                if (vendor != null)
                {
                    vendor.CreditRating = "A";
                    vendor.Id = GetNextId();
                    break;
                }

                BusinessEntity business = entity as BusinessEntity;
                if (business != null)
                {
                    business.Id = GetNextId();
                    break;
                }
            }
            return variousEntities;
        }

        public BusinessEntity SaveBusiness(BusinessEntity business)
        {
            if (business != null)
            {
                business.Id = GetNextId();
            }

            return business;
        }

        public CustomerEntity SaveCustomer(CustomerEntity customer)
        {
            if (customer != null)
            {
                customer.ApprovalDate = DateTime.Now;
                customer.Id = GetNextId();
            }

            return customer;
        }

        public VendorEntity SaveVendor(VendorEntity vendor)
        {
            if (vendor != null)
            {
                vendor.CreditRating = "A";
                vendor.Id = GetNextId();
            }

            return vendor;
        }

        int GetNextId()
        {
            Random random = new Random();
            return random.Next();
        }
    }

    #endregion
}
